/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.te.TEInventory;
import net.dries007.tfc.objects.te.TEPitKiln;
import net.dries007.tfc.util.Helpers;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
public class TEPlacedItem
extends TEInventory {
    public static final int SLOT_LARGE_ITEM = 0;
    protected boolean isHoldingLargeItem = false;

    public static void convertPitKilnToPlacedItem(World world, BlockPos pos) {
        TEPitKiln teOld = Helpers.getTE((IBlockAccess)world, pos, TEPitKiln.class);
        if (teOld != null) {
            IItemHandler capOld = (IItemHandler)teOld.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack[] inventory = new ItemStack[4];
            if (capOld != null) {
                for (int i = 0; i < 4; ++i) {
                    inventory[i] = capOld.extractItem(i, 64, false);
                }
            }
            world.func_175656_a(pos, BlocksTFC.PLACED_ITEM.func_176223_P());
            TEPlacedItem teNew = Helpers.getTE((IBlockAccess)world, pos, TEPlacedItem.class);
            if (teNew != null) {
                IItemHandler capNew = (IItemHandler)teNew.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (capNew != null) {
                    for (int i = 0; i < 4; ++i) {
                        if (inventory[i] == null || inventory[i].func_190926_b()) continue;
                        capNew.insertItem(i, inventory[i], false);
                    }
                }
                teNew.isHoldingLargeItem = teOld.isHoldingLargeItem;
            }
        }
    }

    public TEPlacedItem() {
        super(4);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
    }

    public boolean onRightClick(EntityPlayer player, ItemStack stack, RayTraceResult rayTrace) {
        return this.onRightClick(player, stack, (double)Math.round(rayTrace.field_72307_f.field_72450_a) < rayTrace.field_72307_f.field_72450_a, (double)Math.round(rayTrace.field_72307_f.field_72449_c) < rayTrace.field_72307_f.field_72449_c);
    }

    public boolean insertItem(EntityPlayer player, ItemStack stack, RayTraceResult rayTrace) {
        boolean x = (double)Math.round(rayTrace.field_72307_f.field_72450_a) < rayTrace.field_72307_f.field_72450_a;
        boolean z = (double)Math.round(rayTrace.field_72307_f.field_72449_c) < rayTrace.field_72307_f.field_72449_c;
        int slot = (x ? 1 : 0) + (z ? 2 : 0);
        return this.insertItem(player, stack, slot);
    }

    public boolean onRightClick(EntityPlayer player, ItemStack stack, boolean x, boolean z) {
        int slot = (x ? 1 : 0) + (z ? 2 : 0);
        if (player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_70093_af()) {
            ItemStack current = this.isHoldingLargeItem ? this.inventory.getStackInSlot(0) : this.inventory.getStackInSlot(slot);
            if (!current.func_190926_b()) {
                player.func_191521_c(current.func_77979_a(1));
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
                this.isHoldingLargeItem = false;
                this.updateBlock();
                return true;
            }
        } else if (!stack.func_190926_b()) {
            return this.insertItem(player, stack, slot);
        }
        return false;
    }

    public boolean insertItem(EntityPlayer player, ItemStack stack, int slot) {
        IItemSize sizeCap = CapabilityItemSize.getIItemSize(stack);
        Size size = Size.NORMAL;
        if (sizeCap != null) {
            size = sizeCap.getSize(stack);
        }
        if (size.isSmallerThan(Size.VERY_LARGE) && !this.isHoldingLargeItem) {
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                ItemStack input;
                if (player.func_184812_l_()) {
                    input = stack.func_77946_l();
                    input.func_190920_e(1);
                } else {
                    input = stack.func_77979_a(1);
                }
                this.inventory.setStackInSlot(slot, input);
                this.updateBlock();
                return true;
            }
        } else if (!size.isSmallerThan(Size.VERY_LARGE) && this.isEmpty()) {
            ItemStack input;
            if (player.func_184812_l_()) {
                input = stack.func_77946_l();
                input.func_190920_e(1);
            } else {
                input = stack.func_77979_a(1);
            }
            this.inventory.setStackInSlot(0, input);
            this.isHoldingLargeItem = true;
            this.updateBlock();
            return true;
        }
        return false;
    }

    public boolean holdingLargeItem() {
        return this.isHoldingLargeItem;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.isHoldingLargeItem = nbt.func_74767_n("itemSize");
        super.func_145839_a(nbt);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("itemSize", this.isHoldingLargeItem);
        return super.func_189515_b(nbt);
    }

    protected void updateBlock() {
        if (this.isEmpty()) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        } else {
            this.markForBlockUpdate();
        }
    }

    protected boolean isEmpty() {
        if (this.isHoldingLargeItem && this.inventory.getStackInSlot(0).func_190926_b()) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

